(function() {
  //    FILE:EventModel
  //    PROJECT:fw-mobile
  //    Created by Rafa Dorado on 2/18/13
  //    Farmerswife SL.
  define(['Backbone', 'moment', 'models/request/RequestModel', 'collections/objects/ObjectCollection'], function(Backbone, Moment, RequestModel, ObjectCollection) {
    var ObjectModel;
    return ObjectModel = class ObjectModel extends Backbone.Model {
      initialize(usr1) {
        this.usr = usr1;
        //console.log "Model ContactModel initialized"
        return this.reqMdl = new RequestModel();
      }

      set_object_detail(usr, objName, objID, objType, objViewName, objClassID, bookingTypeID) {
        return this.set({
          objectName: objName,
          objectType: objType,
          objectID: objID,
          objectViewName: objViewName,
          objectClassID: objClassID,
          bookingTypeID: bookingTypeID || ""
        });
      }

      set_favorite(usr, objID, objType, groupName, fav) {
        var jsonReq, response, that, xmlReq;
        $.mobile.loading('show');
        if (fav) {
          //WE SAVE AS FAVORITE
          jsonReq = this.reqMdl.get('JAddFavorite');
          this.reqMdl.__setNodeValue(jsonReq, 'sessionID', usr.get('sessionID'));
          this.reqMdl.__setNodeValue(jsonReq, 'objectID', objID);
          this.reqMdl.__setNodeValue(jsonReq, 'objectType', objType);
          this.reqMdl.__setNodeValue(jsonReq, 'groupName', groupName);
          xmlReq = this.reqMdl.__getXML(jsonReq);
          that = this;
          response = this.reqMdl.__send_server_xmlrequest(xmlReq);
          return response.done(function(data, textStatus, jqXHR) {
            var jsonObj;
            jsonObj = data;
            //console.log data
            if (jsonObj.Result.isExpiredSession === '1' || jsonObj.Result.isExpiredSession === 1) {
              window.localStorage.clear();
              window.location.href = 'index.html?expired=1';
            }
            if (jsonObj.Result.isError === "0" || jsonObj.Result.isError === 0) {
              return that.trigger('addedFavorite');
            }
          }).fail(function(data, textStatus, jqXHR) {
            //console.log "ERROR #{textStatus} "+data
            return false;
          }).always(function(data, textStatus) {
            return $.mobile.loading('hide');
          });
        } else {
          jsonReq = this.reqMdl.get('JRemoveFavorite');
          this.reqMdl.__setNodeValue(jsonReq, 'sessionID', usr.get('sessionID'));
          this.reqMdl.__setNodeValue(jsonReq, 'objectID', objID);
          this.reqMdl.__setNodeValue(jsonReq, 'groupName', groupName);
          xmlReq = this.reqMdl.__getXML(jsonReq);
          that = this;
          response = this.reqMdl.__send_server_xmlrequest(xmlReq);
          return response.done(function(data, textStatus, jqXHR) {
            var jsonObj;
            jsonObj = data;
            //console.log data
            if (jsonObj.Result.isExpiredSession === '1' || jsonObj.Result.isExpiredSession === 1) {
              window.localStorage.clear();
              window.location.href = 'index.html?expired=1';
            }
            if (jsonObj.Result.isError === "0" || jsonObj.Result.isError === 0) {
              return that.trigger('removedFavorite');
            }
          }).fail(function(data, textStatus, jqXHR) {
            //console.log "ERROR #{textStatus} "+data
            return false;
          }).always(function(data, textStatus) {
            return $.mobile.loading('hide');
          });
        }
      }

      get_object_activity(objID) {
        var allObjects, colName, obj;
        colName = 'SimpleObjects-' + window.localStorage.getItem('SimpleObjects');
        allObjects = JSON.parse(window.localStorage.getItem(colName));
        obj = _.findWhere(allObjects, {
          objectID: objID
        });
        if (obj) {
          return obj.A;
        } else {
          return [];
        }
      }

      get_object_class(objID) {
        var allObjects, arrClasses, classes, colName, i, j, len, obj, objCol;
        colName = 'SimpleObjects-' + window.localStorage.getItem('SimpleObjects');
        allObjects = JSON.parse(window.localStorage.getItem(colName));
        if (!allObjects) {
          objCol = new ObjectCollection();
          objCol.get_simple_objects(this.usr);
        }
        obj = _.findWhere(allObjects, {
          objectID: objID
        });
        classes = [];
        if (obj && obj.objectClassID) {
          arrClasses = obj.objectClassID;
          if (!_.isArray(arrClasses)) {
            arrClasses = [arrClasses];
          }
          for (j = 0, len = arrClasses.length; j < len; j++) {
            i = arrClasses[j];
            obj = _.findWhere(allObjects, {
              objectID: i
            });
            classes.push(obj);
          }
        }
        return classes;
      }

      __get_object_icon() {
        if (this) {
          if (this.get('objectType') === 'objectClass' || this.get('objectType') === "smartEventsView" || this.get('objectType') === "dayPlan" || this.get('objectType') === "sharedEventsView" || (this.get('objectType') === 'smartEventsView' && this.get('objectID') === 'allEvents')) {
            return 'fwi-object-browser';
          } else if (this.get('objectType').indexOf('user') !== -1 || this.get('objectType') === 'resource' || (this.get('objectType') === 'smartEventsView' && this.get('objectID') === 'myEvents') || (this.get('objectType') === 'smartEventsView' && this.get('objectID') === 'myRelatedEvents')) {
            return 'fwi-contact';
          } else {
            return 'fwi-obj';
          }
        }
      }

    };
  });

}).call(this);
